//: ## ![3DaysOfSwift.com Logo](PageHeader.png) ✅ Swift Study Guide
//: ### Study These Language Features
//: ©️ copyright of [3DaysOfSwift.com](https://www.3DaysOfSwift.com) | [3 Days of Swift Bootcamp](https://www.3DaysOfSwift.com/bootcamp) | [Interview Prep](https://www.3DaysOfSwift.com/interview-prep)
//:
//: -------------------
//:
//: ## ✅ Generics
//:
//: Swift code is specific to only one type.
//:
//: This means code can become duplicated, like the example below.
//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:


import Foundation
// → the problem
func addTwoValues(_ a: Int, _ b: Int) -> Int {
    a + b
}
func addTwoValues(_ a: Double, _ b: Double) -> Double {
    a + b
}
func addTwoValues(_ a: Decimal, _ b: Decimal) -> Decimal {
    a + b
}

// execute these functions
let integerSum = addTwoValues(1, 1)
let doubleSum = addTwoValues(1.0, 1.0)
let decimalSum = addTwoValues(Decimal(1), Decimal(1))


//:
//: -------------------
//:
//: ## Using Swift Generics
//:
//: -------------------
//:


// declare the generic function
func addTwoValuesUsingGenerics<T: AdditiveArithmetic>(_ a: T, _ b: T) -> T {
    a + b
}

// use it
let sum = addTwoValuesUsingGenerics(1, 1)


//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:
//: ![3 Days Of Swift Logo](Footer.png) [Website](https://www.3DaysOfSwift.com) | [3 Days Of Swift Bootcamp](https://www.3DaysOfSwift.com/bootcamp) | [Interview Prep](https://www.3DaysOfSwift.com/interview-prep)
//:
//: © Copyright of [3DaysOfSwift.com](https://www.3DaysOfSwift.com). All rights reserved. Don't forget - come back when you've got an [interview](https://www.3DaysOfSwift.com/interview-prep)!
//:
//: Welcome to our community of [3DaysOfSwift.com](https://www.3DaysOfSwift.com) developers!
//:
//: 🧕🏻🙋🏽‍♂️👨🏿‍💼👩🏼‍💼👩🏻‍💻💁🏼‍♀️👨🏼‍💼🙋🏻‍♂️🙋🏻‍♀️👩🏼‍💻🙋🏿💁🏽‍♂️🙋🏽‍♀️🙋🏿‍♀️🧕🏾🙋🏼‍♂️
//:
